{$i-,s-,g+,r-}
Program Morphology;
{$ifndef modif}{$i modif.inc}{$endif}
uses {$ifdef Windows}
     WinCrtx,WinDos,
     {$else}
       {$ifdef crtx}crtx,{$else}crt,{$endif}dos,
     {$endif}
     pictures;

var vystup,a:string;
    fbr,obr:Picture;
    i,j:integer;
    MaxP,p:Byte;
    x,y:integer;
    MarkedTime:Longint;
    op:char;
    AElement:Word;
    PassLProc:PercentLineProc;


Function GetInterval:Longint; assembler;
asm
	MOV	AH,0
        INT	1Ah
        MOV	AX,DX
        MOV	DX,CX
end;


Label 10,20,30;


const Title:array[0..17]of char='Morphology'#0;
begin
{$ifdef Windows}
ScreenSize.X:=62;
ScreenSize.Y:=10;
WindMax:=ScreenSize;
Move(Title,WindowTitle,Sizeof(Title));
{$endif}

PassLProc.Init;
obr.init;
fbr.init;
{$ifndef  Windows}
  DirectVideo:=False;
  nosound;
  {$endif}
writeln(#10#13'<<< MORPH >>> Mathematical morphology (c)1997-2009 F&TSoft');
vystup:='';
op:='D';
AElement:=El8;

if Paramcount=0 then
	begin
10:	write('Enter name of input picture:');readln(a);
	if a='' then goto 10;
	assignpicture(obr,a);
	write('Enter name of output picture:');readln(a);
	vystup:=a;
20:     write('Enter operation (d:dil,e:ero):');readln(a);
	op:=UpCase(a[1]);
	if (op<>'D')and(op<>'E') then
		     begin
		     writeln('Error:Incorrect operation ',op);
		     goto 20;
		     end;
30:     write('Enter type of element (only 4 or 8):');readln(a);
	if (a[1]<>'4')and(a[1]<>'8') then
		     begin
		     writeln('Error:Incorrect structural type ',a);
		     goto 30;
		     end;
	if a[1]='4' then AElement:=El4; {El8 je implicitni}
	end;

for i:=1 to paramcount do
	begin
	a:=paramStr(i);
	if(a[2]='?')or(a[1]='?') then
		begin
		writeln(#10#13'MORPH file_in file_out [/D|/E] [/El 8|4]'#10#13+
			      'Supported file formats are BMP,OKO,PCX,RAS'#10#13+
			      '/D	dilatation'#10#13+
			      '/E	erosion'#10#13+
			      '/Elx	definition of structural element (El4 means 4 neighbourhood)'#10#13);
		{$ifdef Windows}InactiveWinCrt;{$endif}
		exit;
		end;

	if a[1] in ['/','-'] then
		      begin
		      a:=copy(a,2,length(a)-1);
		      if a<>'' then
			   begin
			   a[1]:=UpCase(a[1]);
			   if a='El4' then begin;AElement:=El4;continue;end;
			   if a='El8' then begin;AElement:=El8;continue;end;
			   op:=UpCase(a[1]);
			   end;
		      end
		else
		  begin
		  if obr.filename=nil then assignpicture(obr,a);
		  vystup:=a;
		  end;

	end;

if (op<>'D')and(op<>'E') then
	begin
	writeln('Error:Incorrect operation ',op);
	{$ifdef Windows}InactiveWinCrt;{$endif}
	exit;
	end;

if obr.filename=nil then
	begin
	writeln('Error:Unknown filename');
	{$ifdef Windows}InactiveWinCrt;{$endif}
	exit;
        end;
write(#13' Loading ');ClrEol;
loadpicture(obr,'',@PassLProc);
if obr.data=nil then
	begin
	writeln(#10#13'Cannot find input picture:''',obr.filename^,'''');
	{$ifdef Windows}InactiveWinCrt;{$endif}
	exit;
	end;

markedTime:=GetInterval;
if op='D' then
	begin
	write(#13' Dilatating ');ClrEol;
	Dilatation(Obr,fbr,El8,@PassLProc);
	end;
if op='E' then
	begin
	write(#13' Erosing ');ClrEol;
	Erosion(Obr,fbr,AElement,@PassLProc);
	end;

obr.Done;
write(#13' Saving ');ClrEol;
if not(savepicture(fbr,vystup,@PassLProc)) then
	begin
        writeln(#10#13'Cannot save Output picture:''',fbr.filename^,'''');
{$ifdef Windows}InactiveWinCrt;{$endif}
	exit;
        end;
write(#13' OK ');ClrEol;
writeln;
fbr.Done;
while PeepError<>0 do writeln('Error: ',GetErrorString(ReadError));
end.
